/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class LorentzForceAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Lorentzkraft", "Ein / Aus", "Umpolen", "Magnet umdrehen", "Stromrichtung", "Magnetfeld", "Lorentzkraft", ""}, {"en", "Lorentz Force", "On / Off", "Reverse current", "Turn magnet", "Current direction", "Magnetic field", "Lorentz force", ""}};
    private int[] gaps = new int[]{20, 5, 5, 20, 5, 5, 20, 0, 20};
    final int width = 640;
    final int width0 = 440;
    final int height = 400;
    final double mx = 40.0;
    final double my1 = 160.0;
    final double my2 = 200.0;
    final double mz1 = 56.0;
    final double mz2 = 80.0;
    final double lx = 64.0;
    final double ly = 64.0;
    final double lz = 128.0;
    final int u0 = 360;
    final int v0 = 250;
    final double theta = 0.2617993877991494;
    final double phi = 0.5235987755982988;
    double a1;
    double a2;
    double b1;
    double b2;
    double b3;
    CanvasAP cv;
    Panel6 pan;
    JButton bOn;
    JButton bDirC;
    JButton bDirM;
    JCheckBox cbC;
    JCheckBox cbM;
    JCheckBox cbL;
    Color bgCanvas;
    Color bgPanel;
    Color colorNorth;
    Color colorSouth;
    Color colorPlus;
    Color colorMinus;
    Color colorField;
    Color colorCurrent;
    Color colorForce;
    Color colorButton1;
    Color colorButton2;
    Color colorButton3;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String coauthor;
    double[] p1X;
    double[] p1Y;
    double[] p2X;
    double[] p2Y;
    Point2D pM1;
    Point2D pM2;
    Point2D pM3;
    Point2D pM4;
    Point2D pL1;
    Point2D pL2;
    Point2D pL3;
    Point2D pL4;
    Point2D pL5;
    Point2D pL6;
    Point2D pL7;
    Point2D pL8;
    Point2D pL9;
    Point2D pL10;
    Point2D pL11;
    Point2D pL12;
    Point2D pL13;
    Point2D pL14;
    Point2D pA1;
    Point2D pA2;
    boolean on;
    int dirC;
    int dirM;
    boolean arrC;
    boolean arrM;
    boolean arrL;
    double alpha;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(640, 400);
    }

    @Override
    protected void initAttributes() {
        this.a1 = Math.sin(0.5235987755982988);
        this.a2 = -Math.cos(0.5235987755982988);
        this.b1 = -Math.sin(0.2617993877991494) * Math.cos(0.5235987755982988);
        this.b2 = -Math.sin(0.2617993877991494) * Math.sin(0.5235987755982988);
        this.b3 = -Math.cos(0.2617993877991494);
        this.initPolygons();
        this.initPoints();
        this.on = false;
        this.dirM = 1;
        this.dirC = 1;
        this.arrL = true;
        this.arrM = true;
        this.arrC = true;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorNorth = this.getColor(new Color(255, 128, 0), "colorNorth");
        this.colorSouth = this.getColor(Color.green, "colorSouth");
        this.colorPlus = this.getColor(Color.red, "colorPlus");
        this.colorMinus = this.getColor(Color.blue, "colorMinus");
        this.colorField = this.getColor(Color.blue, "colorField");
        this.colorCurrent = this.getColor(Color.red, "colorCurrent");
        this.colorForce = this.getColor(Color.black, "colorForce");
        this.colorButton1 = this.getColor(Color.orange, "colorButton1");
        this.colorButton2 = this.getColor(Color.red, "colorButton2");
        this.colorButton3 = this.getColor(Color.cyan, "colorButton3");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.coauthor = this.getText(t[8], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 440, 400);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 1, this.gaps);
        this.pan.setBounds(440, 0, 200, 400);
        this.bOn = this.pan.newButton(this.text01, this.colorButton1);
        this.bDirC = this.pan.newButton(this.text02, this.colorButton2);
        this.bDirM = this.pan.newButton(this.text03, this.colorButton3);
        this.cbC = new JCheckBox(this.text04, true);
        this.pan.add(this.cbC, this.bgPanel, this.colorCurrent);
        this.cbM = new JCheckBox(this.text05, true);
        this.pan.add(this.cbM, this.bgPanel, this.colorField);
        this.cbL = new JCheckBox(this.text06, true);
        this.pan.add(this.cbL, this.bgPanel, this.colorForce);
        this.pan.add(1998);
        this.add(this.pan);
        this.pan.add(this.coauthor);
        this.cbC.addActionListener(this);
        this.cbM.addActionListener(this);
        this.cbL.addActionListener(this);
    }

    @Override
    public void run() {
    }

    double screenU(double x, double y) {
        return 360.0 + this.a1 * x + this.a2 * y;
    }

    double screenV(double x, double y, double z) {
        return 250.0 + this.b1 * x + this.b2 * y + this.b3 * z;
    }

    Point2D screenCoords(double x, double y, double z) {
        double u = this.screenU(x, y);
        double v = this.screenV(x, y, z);
        return new Point2D.Double(u, v);
    }

    void setPoint(double[] px, double[] py, int i, double x, double y, double z) {
        px[i] = this.screenU(x, y);
        py[i] = this.screenV(x, y, z);
    }

    void setPoint1(int i, double x, double y, double z) {
        this.setPoint(this.p1X, this.p1Y, i, x, y, z);
    }

    void setPoint2(int i, double x, double y, double z) {
        this.setPoint(this.p2X, this.p2Y, i, x, y, z);
    }

    void initPolygons() {
        this.p1X = new double[9];
        this.p1Y = new double[9];
        this.setPoint1(0, -40.0, 200.0, 0.0);
        this.setPoint1(1, -40.0, 200.0, -80.0);
        this.setPoint1(2, -40.0, 0.0, -80.0);
        this.setPoint1(3, 40.0, 0.0, -80.0);
        this.setPoint1(4, 40.0, 0.0, -56.0);
        this.setPoint1(5, 40.0, 160.0, -56.0);
        this.setPoint1(6, 40.0, 160.0, 0.0);
        this.setPoint1(7, -40.0, 160.0, 0.0);
        this.setPoint1(8, -40.0, 200.0, 0.0);
        this.pM1 = this.screenCoords(-40.0, 160.0, -56.0);
        this.pM2 = this.screenCoords(-40.0, 0.0, -56.0);
        this.p2X = new double[10];
        this.p2Y = new double[10];
        this.setPoint2(0, -40.0, 200.0, 0.0);
        this.setPoint2(1, -40.0, 200.0, 80.0);
        this.setPoint2(2, 40.0, 200.0, 80.0);
        this.setPoint2(3, 40.0, 0.0, 80.0);
        this.setPoint2(4, 40.0, 0.0, 56.0);
        this.setPoint2(5, -40.0, 0.0, 56.0);
        double lambda = (this.pM2.getX() - this.p1X[5]) / (this.pM2.getX() - this.pM1.getX());
        Point2D pt0 = this.screenCoords(-40.0, lambda * 160.0, 56.0);
        this.p2X[6] = pt0.getX();
        this.p2Y[6] = pt0.getY();
        this.setPoint2(7, 40.0, 160.0, 0.0);
        this.setPoint2(8, -40.0, 160.0, 0.0);
        this.setPoint2(9, -40.0, 200.0, 0.0);
        this.pM3 = this.screenCoords(-40.0, 160.0, 56.0);
        this.pM4 = this.screenCoords(-40.0, 0.0, 80.0);
    }

    void initPoints() {
        this.pL1 = this.screenCoords(-64.0, 64.0, 128.0);
        this.pL4 = this.screenCoords(64.0, 64.0, 128.0);
        this.pL5 = this.screenCoords(-64.0, 64.0, 148.0);
        int dl = 240;
        this.pL6 = this.screenCoords(-64.0, 64.0 + (double)dl, 148.0);
        this.pL7 = this.screenCoords(-64.0, 64.0 + (double)dl, 0.0);
        this.pL8 = this.screenCoords(-64.0, 64.0 + (double)dl, -40.0);
        this.pL9 = this.screenCoords(-64.0, 64.0 + (double)dl, -80.0);
        this.pL10 = this.screenCoords(-30.0, 64.0 + (double)dl, -80.0);
        this.pL11 = this.screenCoords(30.0, 64.0 + (double)dl, -80.0);
        this.pL12 = this.screenCoords(64.0, 64.0 + (double)dl, -80.0);
        this.pL13 = this.screenCoords(64.0, 64.0 + (double)dl, 148.0);
        this.pL14 = this.screenCoords(64.0, 64.0, 148.0);
        this.pA1 = this.screenCoords(-94.0, 64.0, 128.0);
        this.pA2 = this.screenCoords(94.0, 64.0, 128.0);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.arrC = this.cbC.isSelected();
        this.arrM = this.cbM.isSelected();
        this.arrL = this.cbL.isSelected();
        Object o = ae.getSource();
        if (o == this.bOn) {
            this.on = !this.on;
        } else if (o == this.bDirC) {
            this.dirC = -this.dirC;
        } else if (o == this.bDirM) {
            this.dirM = -this.dirM;
        }
        this.cv.repaint();
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, LorentzForceAP.this.bgCanvas);
        }

        void line(Graphics2D g, double d, Point2D p1, Point2D p2) {
            CanvasAP.line(g, d, p1.getX(), p1.getY(), p2.getX(), p2.getY());
        }

        void line(Graphics2D g, Point2D p1, Point2D p2) {
            CanvasAP.line(g, p1.getX(), p1.getY(), p2.getX(), p2.getY());
        }

        void lines(Graphics2D g, Point2D p0, double[] px, double[] py, int i1, int i2) {
            CanvasAP.line(g, p0.getX(), p0.getY(), px[i1], py[i1]);
            CanvasAP.line(g, p0.getX(), p0.getY(), px[i2], py[i2]);
        }

        void thickArrow(Graphics2D g, Point2D p0, Point2D p1, double lambda) {
            double u = p0.getX() + lambda * (p1.getX() - p0.getX());
            double v = p0.getY() + lambda * (p1.getY() - p0.getY());
            CanvasAP.arrow(g, 3.0, p0.getX(), p0.getY(), u, v);
        }

        void thickCircle(Graphics2D g, Point2D m) {
            Color c = LorentzForceAP.this.on ? LorentzForceAP.this.colorCurrent : Color.black;
            CanvasAP.circle(g, 2.0, m.getX(), m.getY(), 4.0, c, false);
            CanvasAP.circle(g, m.getX(), m.getY(), 3.0, LorentzForceAP.this.bgCanvas);
        }

        void magnetLow(Graphics2D g) {
            Color c = LorentzForceAP.this.dirM == 1 ? LorentzForceAP.this.colorSouth : LorentzForceAP.this.colorNorth;
            CanvasAP.polygon(g, LorentzForceAP.this.p1X, LorentzForceAP.this.p1Y, c, true);
            this.lines(g, LorentzForceAP.this.pM1, LorentzForceAP.this.p1X, LorentzForceAP.this.p1Y, 7, 5);
            this.line(g, LorentzForceAP.this.pM1, LorentzForceAP.this.pM2);
            this.lines(g, LorentzForceAP.this.pM2, LorentzForceAP.this.p1X, LorentzForceAP.this.p1Y, 2, 4);
        }

        void magnetHigh(Graphics2D g) {
            Color c = LorentzForceAP.this.dirM == 1 ? LorentzForceAP.this.colorNorth : LorentzForceAP.this.colorSouth;
            CanvasAP.polygon(g, LorentzForceAP.this.p2X, LorentzForceAP.this.p2Y, c, true);
            this.lines(g, LorentzForceAP.this.pM3, LorentzForceAP.this.p2X, LorentzForceAP.this.p2Y, 8, 5);
            CanvasAP.line(g, LorentzForceAP.this.p2X[1], LorentzForceAP.this.p2Y[1], LorentzForceAP.this.pM4.getX(), LorentzForceAP.this.pM4.getY());
            this.lines(g, LorentzForceAP.this.pM4, LorentzForceAP.this.p2X, LorentzForceAP.this.p2Y, 5, 3);
        }

        void conductorFG(Graphics2D g) {
            double y = 64.0 - 128.0 * Math.sin(LorentzForceAP.this.alpha);
            double z = 128.0 * (1.0 - Math.cos(LorentzForceAP.this.alpha));
            LorentzForceAP.this.pL2 = LorentzForceAP.this.screenCoords(-64.0, y, z);
            g.setColor(LorentzForceAP.this.on ? LorentzForceAP.this.colorCurrent : Color.black);
            this.line(g, 3.0, LorentzForceAP.this.pL1, LorentzForceAP.this.pL2);
        }

        void conductorBG(Graphics2D g) {
            double y = 64.0 - 128.0 * Math.sin(LorentzForceAP.this.alpha);
            double z = 128.0 * (1.0 - Math.cos(LorentzForceAP.this.alpha));
            LorentzForceAP.this.pL2 = LorentzForceAP.this.screenCoords(-64.0, y, z);
            LorentzForceAP.this.pL3 = LorentzForceAP.this.screenCoords(64.0, y, z);
            g.setColor(LorentzForceAP.this.on ? LorentzForceAP.this.colorCurrent : Color.black);
            this.line(g, 3.0, LorentzForceAP.this.pL2, LorentzForceAP.this.pL3);
            this.line(g, 3.0, LorentzForceAP.this.pL3, LorentzForceAP.this.pL4);
        }

        void wires(Graphics2D g) {
            double lambda;
            g.setColor(LorentzForceAP.this.on ? LorentzForceAP.this.colorCurrent : Color.black);
            this.line(g, 3.0, LorentzForceAP.this.pL1, LorentzForceAP.this.pL5);
            this.line(g, 3.0, LorentzForceAP.this.pL5, LorentzForceAP.this.pL6);
            this.line(g, 3.0, LorentzForceAP.this.pL6, LorentzForceAP.this.pL7);
            this.line(g, 3.0, LorentzForceAP.this.pL6, LorentzForceAP.this.pL7);
            this.line(g, 3.0, LorentzForceAP.this.pL8, LorentzForceAP.this.pL9);
            this.line(g, 3.0, LorentzForceAP.this.pL9, LorentzForceAP.this.pL10);
            this.line(g, 3.0, LorentzForceAP.this.pL11, LorentzForceAP.this.pL12);
            this.line(g, 3.0, LorentzForceAP.this.pL12, LorentzForceAP.this.pL13);
            this.line(g, 3.0, LorentzForceAP.this.pL13, LorentzForceAP.this.pL14);
            this.line(g, 3.0, LorentzForceAP.this.pL14, LorentzForceAP.this.pL4);
            if (LorentzForceAP.this.on) {
                CanvasAP.line(g, 3.0, LorentzForceAP.this.pL8.getX(), LorentzForceAP.this.pL8.getY(), LorentzForceAP.this.pL7.getX() - 5.0, LorentzForceAP.this.pL7.getY() - 10.0);
            } else {
                CanvasAP.line(g, 3.0, LorentzForceAP.this.pL8.getX(), LorentzForceAP.this.pL8.getY(), LorentzForceAP.this.pL7.getX() - 20.0, LorentzForceAP.this.pL7.getY() - 6.0);
            }
            this.thickCircle(g, LorentzForceAP.this.pL7);
            this.thickCircle(g, LorentzForceAP.this.pL8);
            this.thickCircle(g, LorentzForceAP.this.pL10);
            this.thickCircle(g, LorentzForceAP.this.pL11);
            int x = (int)(LorentzForceAP.this.dirC > 0 ? LorentzForceAP.this.pL11.getX() : LorentzForceAP.this.pL10.getX());
            int y = (int)(LorentzForceAP.this.dirC > 0 ? LorentzForceAP.this.pL11.getY() : LorentzForceAP.this.pL10.getY());
            g.setColor(LorentzForceAP.this.colorPlus);
            g.fillRect(x - 5, y + 14, 11, 3);
            g.fillRect(x - 1, y + 10, 3, 11);
            g.setColor(LorentzForceAP.this.colorMinus);
            x = (int)(LorentzForceAP.this.dirC > 0 ? LorentzForceAP.this.pL10.getX() : LorentzForceAP.this.pL11.getX());
            y = (int)(LorentzForceAP.this.dirC > 0 ? LorentzForceAP.this.pL10.getY() : LorentzForceAP.this.pL11.getY());
            g.fillRect(x - 5, y + 14, 11, 3);
            g.setColor(Color.black);
            this.line(g, 3.0, LorentzForceAP.this.pA1, LorentzForceAP.this.pA2);
            g.setColor(LorentzForceAP.this.on ? LorentzForceAP.this.colorCurrent : Color.black);
            if (!LorentzForceAP.this.on || !LorentzForceAP.this.arrC) {
                return;
            }
            double d = lambda = LorentzForceAP.this.dirM > 0 ? 0.85 : 0.95;
            if (LorentzForceAP.this.dirC > 0) {
                this.thickArrow(g, LorentzForceAP.this.pL5, LorentzForceAP.this.pL6, 0.5);
                this.thickArrow(g, LorentzForceAP.this.pL6, LorentzForceAP.this.pL7, 0.5);
                this.thickArrow(g, LorentzForceAP.this.pL12, LorentzForceAP.this.pL13, 0.5);
                this.thickArrow(g, LorentzForceAP.this.pL13, LorentzForceAP.this.pL14, 0.5);
                this.thickArrow(g, LorentzForceAP.this.pL3, LorentzForceAP.this.pL2, lambda);
            } else {
                this.thickArrow(g, LorentzForceAP.this.pL6, LorentzForceAP.this.pL5, 0.5);
                this.thickArrow(g, LorentzForceAP.this.pL7, LorentzForceAP.this.pL6, 0.5);
                this.thickArrow(g, LorentzForceAP.this.pL13, LorentzForceAP.this.pL12, 0.5);
                this.thickArrow(g, LorentzForceAP.this.pL14, LorentzForceAP.this.pL13, 0.5);
                this.thickArrow(g, LorentzForceAP.this.pL2, LorentzForceAP.this.pL3, lambda);
            }
        }

        void fieldLine(Graphics2D g, double y) {
            Point2D p0 = LorentzForceAP.this.screenCoords(0.0, y, 56.0);
            Point2D p1 = LorentzForceAP.this.screenCoords(0.0, y, -56.0);
            g.setColor(LorentzForceAP.this.colorField);
            this.line(g, 3.0, p0, p1);
            if (LorentzForceAP.this.dirM > 0) {
                this.thickArrow(g, p0, p1, 0.35);
                this.thickArrow(g, p0, p1, 0.85);
            } else {
                this.thickArrow(g, p1, p0, 0.25);
                this.thickArrow(g, p1, p0, 0.75);
            }
        }

        void forceArrow(Graphics2D g) {
            double y = 64.0 - 128.0 * Math.sin(LorentzForceAP.this.alpha);
            double z = 128.0 * (1.0 - Math.cos(LorentzForceAP.this.alpha));
            int lArrow = -LorentzForceAP.this.dirC * LorentzForceAP.this.dirM * 50;
            double u0 = LorentzForceAP.this.screenU(0.0, y);
            double v0 = LorentzForceAP.this.screenV(0.0, y, z);
            double u1 = LorentzForceAP.this.screenU(0.0, y + (double)lArrow);
            double v1 = LorentzForceAP.this.screenV(0.0, y + (double)lArrow, z);
            g.setColor(LorentzForceAP.this.colorForce);
            CanvasAP.arrow(g, 3.0, u0, v0, u1, v1);
        }

        @Override
        public void paint(Graphics g) {
            double y;
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            double dy = 24.0;
            LorentzForceAP.this.alpha = LorentzForceAP.this.on ? (double)(15 * LorentzForceAP.this.dirC * LorentzForceAP.this.dirM) * (Math.PI / 180) : 0.0;
            this.magnetLow(g2);
            if (LorentzForceAP.this.arrM) {
                for (y = 64.0 + 2.0 * dy; y > 64.0 - 2.5 * dy; y -= dy) {
                    if (y < 64.0 - 128.0 * Math.sin(LorentzForceAP.this.alpha)) continue;
                    this.fieldLine(g2, y);
                }
            }
            this.conductorBG(g2);
            if (LorentzForceAP.this.arrM) {
                for (y = 64.0 + 2.0 * dy; y > 64.0 - 2.5 * dy; y -= dy) {
                    if (y >= 64.0 - 128.0 * Math.sin(LorentzForceAP.this.alpha)) continue;
                    this.fieldLine(g2, y);
                }
            }
            this.magnetHigh(g2);
            if (LorentzForceAP.this.arrL && LorentzForceAP.this.alpha < 0.0) {
                this.forceArrow(g2);
            }
            this.conductorFG(g2);
            this.wires(g2);
            if (LorentzForceAP.this.arrL && LorentzForceAP.this.alpha > 0.0) {
                this.forceArrow(g2);
            }
        }
    }
}

